<?php

/**

 * PA WPML Fancy Text.

 */



namespace PremiumAddons\Compatibility\WPML\Widgets;



use WPML_Elementor_Module_With_Items;



if ( ! defined( 'ABSPATH' ) ) {

	exit; // No access of directly access.

}



/**

 * Fancy Text

 *

 * Registers translatable widget with items.

 *

 * @since 3.1.9

 */

class FancyText extends WPML_Elementor_Module_With_Items {



	/**

	 * Retrieve the field name.

	 *

	 * @since 3.1.9

	 * @return string

	 */

	public function get_items_field() {

		return 'premium_fancy_text_strings';

	}



	/**

	 * Retrieve the fields inside the repeater.

	 *

	 * @since 3.1.9

	 *

	 * @return array

	 */

	public function get_fields() {

		return array(

			'premium_text_strings_text_field',

		);

	}



	/**

	 * Get the title for each repeater string

	 *

	 * @since 3.1.9

	 *

	 * @param string $field control ID.

	 *

	 * @return string

	 */

	protected function get_title( $field ) {



		return __( 'Fancy Text: String', 'premium-addons-for-elementor' );



	}



	/**

	 * Get `editor_type` for each repeater string

	 *

	 * @since 3.1.9

	 *

	 * @param string $field control ID.

	 *

	 * @return string

	 */

	protected function get_editor_type( $field ) {



		return 'LINE';

	}



}

