<?php



namespace PremiumAddons\Modules\Woocommerce\Skins;



use Elementor\Controls_Manager;

use Elementor\Core\Kits\Documents\Tabs\Global_Colors;

use Elementor\Core\Kits\Documents\Tabs\Global_Typography;

use Elementor\Repeater;

use Elementor\Group_Control_Typography;

use Elementor\Group_Control_Background;

use Elementor\Group_Control_Box_Shadow;

use Elementor\Group_Control_Text_Shadow;

use Elementor\Group_Control_Border;





use PremiumAddons\Modules\Woocommerce\TemplateBlocks\Skin_Init;



if ( ! defined( 'ABSPATH' ) ) {

	exit; // If this file is called directly, abort.

}



/**

 * Class Skin_Grid_Default

 *

 * @property Products $parent

 */

class Skin_4 extends Skin_Base {



	/**

	 * Get ID.

	 *

	 * @since 4.7.0

	 * @access public

	 */

	public function get_id() {

		return 'grid-4';

	}



	/**

	 * Get title.

	 *

	 * @since 4.7.0

	 * @access public

	 */

	public function get_title() {

		return __( 'Skin 4', 'premium-addons-for-elementor' );

	}



	/**

	 * Register control actions.

	 *

	 * @since 4.7.0

	 * @access protected

	 */

	protected function _register_controls_actions() {



		// Content Controls

		add_action( 'elementor/element/premium-woo-products/section_pagination_options/after_section_end', array( $this, 'register_display_options_controls' ) );



		// Sale Ribbon Controls

		add_action( 'elementor/element/premium-woo-products/section_pagination_options/after_section_end', array( $this, 'register_sale_products_controls' ) );



		// Featured Ribbon Controls

		add_action( 'elementor/element/premium-woo-products/section_pagination_options/after_section_end', array( $this, 'register_featured_products_controls' ) );



		// Quick View Controls

		add_action( 'elementor/element/premium-woo-products/section_pagination_options/after_section_end', array( $this, 'register_quick_view_controls' ) );



		// Product Overlay Style

		add_action( 'elementor/element/premium-woo-products/section_image_style/after_section_end', array( $this, 'register_image_overlay' ) );



		// Product Title Style

		add_action( 'elementor/element/premium-woo-products/section_image_style/after_section_end', array( $this, 'register_product_title_style' ) );



		// Product Category Style

		add_action( 'elementor/element/premium-woo-products/section_image_style/after_section_end', array( $this, 'register_product_category_style' ) );



		// Product Description Style

		add_action( 'elementor/element/premium-woo-products/section_image_style/after_section_end', array( $this, 'register_product_excerpt_style' ) );



		// Product CTA Style

		add_action( 'elementor/element/premium-woo-products/section_image_style/after_section_end', array( $this, 'register_product_cta_style' ) );



		// Product Sale Ribbon Style

		add_action( 'elementor/element/premium-woo-products/section_image_style/after_section_end', array( $this, 'register_sale_style_controls' ) );



		// Product Featured Ribbon Style

		add_action( 'elementor/element/premium-woo-products/section_image_style/after_section_end', array( $this, 'register_featured_style_controls' ) );



		// Product Quick View Style

		add_action( 'elementor/element/premium-woo-products/section_image_style/after_section_end', array( $this, 'register_quick_style_controls' ), 30 );



		parent::_register_controls_actions();

	}



	public function register_image_overlay() {



		$this->start_controls_section(

			'section_overlay_controls',

			array(

				'label' => __( 'Overlay', 'premium-addons-for-elementor' ),

				'tab'   => Controls_Manager::TAB_STYLE,

			)

		);



		$this->add_group_control(

			Group_Control_Background::get_type(),

			array(

				'name'     => 'overlay_background',

				'types'    => array( 'classic', 'gradient' ),

				'selector' => '{{WRAPPER}} .premium-woo-product-overlay',

			)

		);



		$this->end_controls_section();



	}



	/**

	 * Register content control section.

	 *

	 * @since 4.7.0

	 * @access public

	 */

	public function register_display_options_controls() {



		$this->start_controls_section(

			'section_content_field',

			array(

				'label' => __( 'Display Options', 'premium-addons-for-elementor' ),

			)

		);



		$this->add_control(

			'product_image',

			array(

				'label'   => __( 'Image', 'premium-addons-for-elementor' ),

				'type'    => Controls_Manager::SWITCHER,

				'default' => 'yes',

			)

		);



		$repeater = new REPEATER();



		$repeater->add_control(

			'product_segment',

			array(

				'label'    => __( 'Select Product Segment', 'premium-addons-for-elementor' ),

				'type'     => Controls_Manager::SELECT,

				'options'  => array(

					'title'    => __( 'Title', 'premium-addons-pro' ),

					'category' => __( 'Category', 'premium-addons-pro' ),

					'ratings'  => __( 'Rating', 'premium-addons-pro' ),

					'price'    => __( 'Price', 'premium-addons-pro' ),

					'desc'     => __( 'Excerpt', 'premium-addons-pro' ),

					'cta'      => __( 'Add To Cart', 'premium-addons-pro' ),

				),

				'multiple' => true,

			)

		);



		$this->add_control(

			'product_structure',

			array(

				'label'       => __( 'Product Structure', 'premium-addons-for-elementor' ),

				'type'        => Controls_Manager::REPEATER,

				'default'     => array(

					array(

						'product_segment' => 'title',

					),

					array(

						'product_segment' => 'category',

					),

					array(

						'product_segment' => 'ratings',

					),

					array(

						'product_segment' => 'price',

					),

					array(

						'product_segment' => 'cta',

					),

				),

				'fields'      => $repeater->get_controls(),

				'title_field' => '{{{ product_segment }}}',

			)

		);



		$this->add_responsive_control(

			'alignment',

			array(

				'label'        => __( 'Alignment', 'premium-addons-for-elementor' ),

				'type'         => Controls_Manager::CHOOSE,

				'options'      => array(

					'left'   => array(

						'title' => __( 'Left', 'premium-addons-for-elementor' ),

						'icon'  => 'eicon-text-align-left',

					),

					'center' => array(

						'title' => __( 'Center', 'premium-addons-for-elementor' ),

						'icon'  => 'eicon-text-align-center',

					),

					'right'  => array(

						'title' => __( 'Right', 'premium-addons-for-elementor' ),

						'icon'  => 'eicon-text-align-right',

					),

				),

				'default'      => 'center',

				'toggle'       => false,

				'prefix_class' => 'premium-woo-product-align-',

				'selectors'    => array(

					'{{WRAPPER}} .premium-woo-products-details-wrap'    => 'text-align: {{VALUE}}',

				),

			)

		);



		$this->add_control(

			'cta_position',

			array(

				'label'     => __( 'Add to Cart Position', 'premium-addons-for-elementor' ),

				'type'      => Controls_Manager::SELECT,

				'options'   => array(

					'below' => __( 'Below Content', 'premium-addons-for-elementor' ),

					'above' => __( 'Above Image', 'premium-addons-for-elementor' ),

				),

				'default'   => 'above',

				'condition' => array(

					$this->get_control_id( 'product_image' ) => 'yes',

				),

			)

		);



		$this->end_controls_section();

	}



	public function register_product_title_style() {



		$this->start_controls_section(

			'section_title_style',

			array(

				'label' => __( 'Title', 'premium-addons-for-elementor' ),

				'tab'   => Controls_Manager::TAB_STYLE,

			)

		);



		$this->add_control(

			'title_color',

			array(

				'label'     => __( 'Color', 'premium-addons-for-elementor' ),

				'type'      => Controls_Manager::COLOR,

				'global'    => array(

					'default' => Global_Colors::COLOR_PRIMARY,

				),

				'selectors' => array(

					'{{WRAPPER}} .premium-woocommerce .woocommerce-loop-product__title' => 'color: {{VALUE}};',

				),

			)

		);



		$this->add_control(

			'title_hover_color',

			array(

				'label'     => __( 'Hover Color', 'premium-addons-for-elementor' ),

				'type'      => Controls_Manager::COLOR,

				'global'    => array(

					'default' => Global_Colors::COLOR_PRIMARY,

				),

				'selectors' => array(

					'{{WRAPPER}} .premium-woocommerce .woocommerce-loop-product__title:hover' => 'color: {{VALUE}};',

				),

			)

		);



		$this->add_group_control(

			Group_Control_Typography::get_type(),

			array(

				'name'     => 'title_typography',

				'global'   => array(

					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,

				),

				'selector' => '{{WRAPPER}} .premium-woocommerce .woocommerce-loop-product__title',

			)

		);



		$this->add_group_control(

			Group_Control_Text_Shadow::get_type(),

			array(

				'name'     => 'title_text_shadow',

				'selector' => '{{WRAPPER}} .premium-woocommerce .woocommerce-loop-product__title',

			)

		);



		$this->add_responsive_control(

			'title_spacing',

			array(

				'label'      => __( 'Margin', 'premium-addons-for-elementor' ),

				'type'       => Controls_Manager::DIMENSIONS,

				'size_units' => array( 'px', 'em', '%' ),

				'selectors'  => array(

					'{{WRAPPER}} .premium-woocommerce .woocommerce-loop-product__title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				),

			)

		);



		$this->end_controls_section();



	}



	public function register_product_category_style() {



		$this->start_controls_section(

			'section_category_style',

			array(

				'label' => __( 'Category', 'premium-addons-for-elementor' ),

				'tab'   => Controls_Manager::TAB_STYLE,

			)

		);



		$this->add_control(

			'category_color',

			array(

				'label'     => __( 'Color', 'premium-addons-for-elementor' ),

				'type'      => Controls_Manager::COLOR,

				'global'    => array(

					'default' => Global_Colors::COLOR_TEXT,

				),

				'selectors' => array(

					'{{WRAPPER}} .premium-woocommerce .premium-woo-product-category' => 'color: {{VALUE}};',

				),

			)

		);



		$this->add_group_control(

			Group_Control_Typography::get_type(),

			array(

				'name'     => 'category_typography',

				'global'   => array(

					'default' => Global_Typography::TYPOGRAPHY_TEXT,

				),

				'selector' => '{{WRAPPER}} .premium-woocommerce .premium-woo-product-category',

			)

		);



		$this->add_group_control(

			Group_Control_Text_Shadow::get_type(),

			array(

				'name'     => 'category_text_shadow',

				'selector' => '{{WRAPPER}} .premium-woocommerce .premium-woo-product-category',

			)

		);



		$this->add_responsive_control(

			'category_spacing',

			array(

				'label'      => __( 'Margin', 'premium-addons-for-elementor' ),

				'type'       => Controls_Manager::DIMENSIONS,

				'size_units' => array( 'px', 'em', '%' ),

				'selectors'  => array(

					'{{WRAPPER}} .premium-woocommerce .premium-woo-product-category' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				),

			)

		);



		$this->end_controls_section();



	}



	public function register_product_excerpt_style() {



		$this->start_controls_section(

			'section_desc_style',

			array(

				'label' => __( 'Description', 'premium-addons-for-elementor' ),

				'tab'   => Controls_Manager::TAB_STYLE,

			)

		);



		$this->add_control(

			'desc_color',

			array(

				'label'     => __( 'Color', 'premium-addons-for-elementor' ),

				'type'      => Controls_Manager::COLOR,

				'global'    => array(

					'default' => Global_Colors::COLOR_TEXT,

				),

				'selectors' => array(

					'{{WRAPPER}} .premium-woocommerce .premium-woo-product-desc' => 'color: {{VALUE}};',

				),

			)

		);



		$this->add_group_control(

			Group_Control_Typography::get_type(),

			array(

				'name'     => 'desc_typography',

				'global'   => array(

					'default' => Global_Typography::TYPOGRAPHY_TEXT,

				),

				'selector' => '{{WRAPPER}} .premium-woocommerce .premium-woo-product-desc',

			)

		);



		$this->add_group_control(

			Group_Control_Text_Shadow::get_type(),

			array(

				'name'     => 'desc_text_shadow',

				'selector' => '{{WRAPPER}} .premium-woocommerce .premium-woo-product-desc',

			)

		);



		$this->add_responsive_control(

			'desc_spacing',

			array(

				'label'      => __( 'Margin', 'premium-addons-for-elementor' ),

				'type'       => Controls_Manager::DIMENSIONS,

				'size_units' => array( 'px', 'em', '%' ),

				'selectors'  => array(

					'{{WRAPPER}} .premium-woocommerce .premium-woo-product-desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				),

			)

		);



		$this->end_controls_section();



	}



	public function register_product_cta_style() {



		$this->start_controls_section(

			'section_button_style',

			array(

				'label' => __( 'Add To Cart', 'premium-addons-for-elementor' ),

				'tab'   => Controls_Manager::TAB_STYLE,

			)

		);



		$this->add_group_control(

			Group_Control_Typography::get_type(),

			array(

				'name'      => 'cta_typography',

				'selector'  => '{{WRAPPER}} .premium-woocommerce .premium-woo-products-details-wrap .premium-woo-atc-button .button',

				'global'    => array(

					'default' => Global_Typography::TYPOGRAPHY_ACCENT,

				),

				'condition' => array(

					$this->get_control_id( 'cta_position' ) => 'below',

				),

			)

		);



		$this->add_responsive_control(

			'cta_padding',

			array(

				'label'      => __( 'Padding', 'premium-addons-for-elementor' ),

				'type'       => Controls_Manager::DIMENSIONS,

				'size_units' => array( 'px', 'em', '%' ),

				'selectors'  => array(

					'{{WRAPPER}} .premium-woocommerce .premium-woo-products-details-wrap .premium-woo-atc-button .button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				),

				'condition'  => array(

					$this->get_control_id( 'cta_position' ) => 'below',

				),

			)

		);



		$this->start_controls_tabs( 'cta_style_tabs' );



		$this->start_controls_tab(

			'cta_style_tab_normal',

			array(

				'label' => __( 'Normal', 'premium-addons-for-elementor' ),

			)

		);



		$this->add_control(

			'cta_color',

			array(

				'label'     => __( 'Color', 'premium-addons-for-elementor' ),

				'type'      => Controls_Manager::COLOR,

				'selectors' => array(

					'{{WRAPPER}} .premium-woo-products-details-wrap .premium-woo-atc-button .button, {{WRAPPER}} .premium-woo-cart-btn .premium-woo-add-cart-icon' => 'color: {{VALUE}};',

				),

			)

		);



		$this->add_group_control(

			Group_Control_Background::get_type(),

			array(

				'name'     => 'cta_background',

				'types'    => array( 'classic', 'gradient' ),

				'selector' => '{{WRAPPER}} .premium-woo-products-details-wrap .premium-woo-atc-button .button, {{WRAPPER}} .premium-woo-cart-btn',

			)

		);



		$this->add_group_control(

			Group_Control_Box_Shadow::get_type(),

			array(

				'name'     => 'cta_shadow',

				'selector' => '{{WRAPPER}} .premium-woo-products-details-wrap .premium-woo-atc-button .button, {{WRAPPER}} .premium-woo-cart-btn',

			)

		);



		$this->add_group_control(

			Group_Control_Border::get_type(),

			array(

				'name'     => 'cta_border',

				'selector' => '{{WRAPPER}} .premium-woo-products-details-wrap .premium-woo-atc-button .button, {{WRAPPER}} .premium-woo-cart-btn',

			)

		);



		$this->add_control(

			'cta_radius',

			array(

				'label'      => __( 'Border Radius', 'premium-addons-for-elementor' ),

				'type'       => Controls_Manager::DIMENSIONS,

				'size_units' => array( 'px', 'em', '%' ),

				'selectors'  => array(

					'{{WRAPPER}} .premium-woo-products-details-wrap .premium-woo-atc-button .button, {{WRAPPER}} .premium-woo-cart-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',

				),

			)

		);



		$this->end_controls_tab();



		$this->start_controls_tab(

			'cta_style_tab_hover',

			array(

				'label' => __( 'Hover', 'premium-addons-for-elementor' ),

			)

		);



		$this->add_control(

			'cta_color_hover',

			array(

				'label'     => __( 'Color', 'premium-addons-for-elementor' ),

				'type'      => Controls_Manager::COLOR,

				'selectors' => array(

					'{{WRAPPER}} .premium-woo-products-details-wrap .premium-woo-atc-button .button:hover, {{WRAPPER}} .premium-woo-cart-btn:hover .premium-woo-add-cart-icon' => 'color: {{VALUE}}',

				),

			)

		);



		$this->add_group_control(

			Group_Control_Background::get_type(),

			array(

				'name'     => 'cta_background_hover',

				'types'    => array( 'classic', 'gradient' ),

				'selector' => '{{WRAPPER}} .premium-woocommerce .premium-woo-products-details-wrap .premium-woo-atc-button .button:hover, {{WRAPPER}} .premium-woo-cart-btn:hover',

			)

		);



		$this->add_group_control(

			Group_Control_Box_Shadow::get_type(),

			array(

				'name'     => 'cta_shadow_hover',

				'selector' => '{{WRAPPER}} .premium-woo-products-details-wrap .premium-woo-atc-button .button:hover, {{WRAPPER}} .premium-woo-cart-btn:hover',

			)

		);



		$this->add_group_control(

			Group_Control_Border::get_type(),

			array(

				'name'     => 'cta_border_hover',

				'selector' => '{{WRAPPER}} .premium-woo-products-details-wrap .premium-woo-atc-button .button:hover, {{WRAPPER}} .premium-woo-cart-btn:hover',

			)

		);



		$this->add_control(

			'cta_radius_hover',

			array(

				'label'      => __( 'Border Radius', 'premium-addons-for-elementor' ),

				'type'       => Controls_Manager::DIMENSIONS,

				'size_units' => array( 'px', '%', 'em' ),

				'selectors'  => array(

					'{{WRAPPER}} .premium-woo-products-details-wrap .premium-woo-atc-button .button:hover, {{WRAPPER}} .premium-woo-cart-btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',

				),

			)

		);



		$this->end_controls_tab();



		$this->end_controls_tabs();



		$this->end_controls_section();



	}



	/**

	 * Register pagination control section.

	 *

	 * @since 4.7.0

	 * @access public

	 */

	public function register_sale_products_controls() {



		$this->start_controls_section(

			'section_sale_ribbon_settings',

			array(

				'label' => __( 'Sale Ribbon', 'premium-addons-for-elementor' ),

			)

		);



		$this->add_control(

			'sale',

			array(

				'label'   => __( 'Show Sale Ribbon', 'premium-addons-for-elementor' ),

				'type'    => Controls_Manager::SWITCHER,

				'default' => 'yes',

			)

		);



		$this->add_control(

			'sale_type',

			array(

				'label'     => __( 'Type', 'premium-addons-for-elementor' ),

				'type'      => Controls_Manager::SELECT,

				'options'   => array(

					''       => __( 'Default', 'premium-addons-for-elementor' ),

					'custom' => __( 'Custom', 'premium-addons-for-elementor' ),

				),

				'default'   => '',

				'condition' => array(

					$this->get_control_id( 'sale' ) => 'yes',

				),

			)

		);



		$this->add_control(

			'sale_string',

			array(

				'label'       => __( 'String', 'premium-addons-for-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'default'     => '[value]%',

				'description' => __( 'Show Sale % Value ( [value] Autocalculated offer value will replace this ).', 'premium-addons-for-elementor' ),

				'condition'   => array(

					$this->get_control_id( 'sale' )      => 'yes',

					$this->get_control_id( 'sale_type' ) => 'custom',

				),

			)

		);



		$this->end_controls_section();

	}





	/**

	 * Register Quick View Controls.

	 *

	 * @since 4.7.0

	 * @access public

	 */

	public function register_quick_view_controls() {



		$this->start_controls_section(

			'section_content_quick_view',

			array(

				'label' => __( 'Quick View', 'premium-addons-for-elementor' ),

			)

		);



		$this->add_control(

			'quick_view_notice',

			array(

				'raw'             => __( 'Please make sure that Display Options includes CTA', 'premium-addons-for-elementor' ),

				'type'            => Controls_Manager::RAW_HTML,

				'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',

			)

		);



		$this->add_control(

			'quick_view',

			array(

				'label'   => __( 'Enable Quick View', 'premium-addons-for-elementor' ),

				'type'    => Controls_Manager::SWITCHER,

				'default' => 'yes',

			)

		);



		$this->add_control(

			'quick_view_type',

			array(

				'label'     => __( 'Quick View', 'premium-addons-for-elementor' ),

				'type'      => Controls_Manager::SELECT,

				'options'   => array(

					'button' => __( 'On Button Click', 'premium-addons-for-elementor' ),

					'image'  => __( 'On Image Click', 'premium-addons-for-elementor' ),

				),

				'default'   => 'button',

				'condition' => array(

					$this->get_control_id( 'quick_view' ) => 'yes',

				),

			)

		);



		$this->end_controls_section();

	}



	/**

	 * Register Sale style Controls.

	 *

	 * @since 4.7.0

	 * @access public

	 */

	public function register_sale_style_controls() {



		$this->start_controls_section(

			'section_sale_style',

			array(

				'label'     => __( 'Sale Ribbon', 'premium-addons-for-elementor' ),

				'tab'       => Controls_Manager::TAB_STYLE,

				'condition' => array(

					$this->get_control_id( 'sale' ) => 'yes',

				),

			)

		);



		$this->add_responsive_control(

			'sale_size',

			array(

				'label'      => __( 'Size', 'premium-addons-for-elementor' ),

				'type'       => Controls_Manager::SLIDER,

				'size_units' => array( 'px', 'em' ),

				'range'      => array(

					'px' => array(

						'min' => 20,

						'max' => 200,

					),

				),

				'selectors'  => array(

					'{{WRAPPER}} .premium-woo-product-sale-wrap .premium-woo-product-onsale' => 'min-height: {{SIZE}}{{UNIT}}; min-width: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',

				),

			)

		);



		$this->add_control(

			'sale_color',

			array(

				'label'     => __( 'Color', 'premium-addons-for-elementor' ),

				'type'      => Controls_Manager::COLOR,

				'selectors' => array(

					'{{WRAPPER}} .premium-woo-product-sale-wrap .premium-woo-product-onsale' => 'color: {{VALUE}};',

				),

			)

		);



		$this->add_group_control(

			Group_Control_Typography::get_type(),

			array(

				'name'      => 'sale_typography',

				'global'    => array(

					'default' => Global_Typography::TYPOGRAPHY_TEXT,

				),

				'selector'  => '{{WRAPPER}} .premium-woo-product-sale-wrap .premium-woo-product-onsale',

				'condition' => array(

					$this->get_control_id( 'sale' ) => 'yes',

				),

			)

		);



		$this->add_control(

			'sale_background',

			array(

				'label'     => __( 'Background Color', 'premium-addons-for-elementor' ),

				'type'      => Controls_Manager::COLOR,

				'global'    => array(

					'default' => Global_Colors::COLOR_SECONDARY,

				),

				'selectors' => array(

					'{{WRAPPER}} .premium-woo-product-sale-wrap .premium-woo-product-onsale' => 'background-color: {{VALUE}};',

				),

			)

		);



		$this->add_responsive_control(

			'sale_radius',

			array(

				'label'      => __( 'Border Radius', 'premium-addons-for-elementor' ),

				'type'       => Controls_Manager::DIMENSIONS,

				'size_units' => array( 'px', 'em', '%' ),

				'selectors'  => array(

					'{{WRAPPER}} .premium-woo-product-sale-wrap .premium-woo-product-onsale' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',

				),

			)

		);



		$this->add_group_control(

			Group_Control_Text_Shadow::get_type(),

			array(

				'name'     => 'sale_text_shadow',

				'selector' => '{{WRAPPER}} .premium-woo-product-sale-wrap .premium-woo-product-onsale',

			)

		);



		$this->add_group_control(

			Group_Control_Box_Shadow::get_type(),

			array(

				'name'     => 'sale_shadow',

				'selector' => '{{WRAPPER}} .premium-woo-product-sale-wrap .premium-woo-product-onsale',

			)

		);



		$this->add_responsive_control(

			'sale_margin',

			array(

				'label'      => __( 'Margin', 'premium-addons-for-elementor' ),

				'type'       => Controls_Manager::DIMENSIONS,

				'size_units' => array( 'px', 'em', '%' ),

				'selectors'  => array(

					'{{WRAPPER}} .premium-woo-product-sale-wrap .premium-woo-product-onsale' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				),

			)

		);



		$this->add_responsive_control(

			'sale_padding',

			array(

				'label'      => __( 'Padding', 'premium-addons-for-elementor' ),

				'type'       => Controls_Manager::DIMENSIONS,

				'size_units' => array( 'px', 'em', '%' ),

				'selectors'  => array(

					'{{WRAPPER}} .premium-woo-product-sale-wrap .premium-woo-product-onsale' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				),

			)

		);



		$this->end_controls_section();

	}

	/**

	 * Register pagination control section.

	 *

	 * @since 4.7.0

	 * @access public

	 */

	public function register_featured_products_controls() {



		$this->start_controls_section(

			'section_featured_ribbon_settings',

			array(

				'label' => __( 'Featured Ribbon', 'premium-addons-for-elementor' ),

			)

		);



		$this->add_control(

			'featured',

			array(

				'label' => __( 'Show Featured Ribbon', 'premium-addons-for-elementor' ),

				'type'  => Controls_Manager::SWITCHER,

			)

		);



		$this->add_control(

			'featured_string',

			array(

				'label'     => __( 'String', 'premium-addons-for-elementor' ),

				'type'      => Controls_Manager::TEXT,

				'default'   => __( 'Hot', 'premium-addons-for-elementor' ),

				'condition' => array(

					$this->get_control_id( 'featured' ) => 'yes',

				),

			)

		);



		$this->end_controls_section();

	}



	/**

	 * Register Style Flash Controls.

	 *

	 * @since 4.7.0

	 * @access public

	 */

	public function register_featured_style_controls() {



		$this->start_controls_section(

			'section_featured_style',

			array(

				'label'     => __( 'Featured Ribbon', 'premium-addons-for-elementor' ),

				'tab'       => Controls_Manager::TAB_STYLE,

				'condition' => array(

					$this->get_control_id( 'featured' ) => 'yes',

				),

			)

		);



		$this->add_responsive_control(

			'featured_size',

			array(

				'label'      => __( 'Size', 'premium-addons-for-elementor' ),

				'type'       => Controls_Manager::SLIDER,

				'size_units' => array( 'px', 'em' ),

				'range'      => array(

					'px' => array(

						'min' => 20,

						'max' => 200,

					),

				),

				'selectors'  => array(

					'{{WRAPPER}} .premium-woo-product-featured-wrap .premium-woo-product-featured' => 'min-height: {{SIZE}}{{UNIT}}; min-width: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',

				),

			)

		);



		$this->add_control(

			'featured_color',

			array(

				'label'     => __( 'Color', 'premium-addons-for-elementor' ),

				'type'      => Controls_Manager::COLOR,

				'selectors' => array(

					'{{WRAPPER}} .premium-woo-product-featured-wrap .premium-woo-product-featured' => 'color: {{VALUE}};',

				),

			)

		);



		$this->add_group_control(

			Group_Control_Typography::get_type(),

			array(

				'name'      => 'featured_typography',

				'global'    => array(

					'default' => Global_Typography::TYPOGRAPHY_TEXT,

				),

				'selector'  => '{{WRAPPER}} .premium-woo-product-featured-wrap .premium-woo-product-featured',

				'condition' => array(

					$this->get_control_id( 'featured' ) => 'yes',

				),

			)

		);



		$this->add_control(

			'featured_background',

			array(

				'label'     => __( 'Background Color', 'premium-addons-for-elementor' ),

				'type'      => Controls_Manager::COLOR,

				'global'    => array(

					'default' => Global_Colors::COLOR_PRIMARY,

				),

				'selectors' => array(

					'{{WRAPPER}} .premium-woo-product-featured-wrap .premium-woo-product-featured' => 'background-color: {{VALUE}};',

				),

			)

		);



		$this->add_responsive_control(

			'featured_radius',

			array(

				'label'      => __( 'Border Radius', 'premium-addons-for-elementor' ),

				'type'       => Controls_Manager::DIMENSIONS,

				'size_units' => array( 'px', 'em', '%' ),

				'selectors'  => array(

					'{{WRAPPER}} .premium-woo-product-featured-wrap .premium-woo-product-featured' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				),

			)

		);



		$this->add_group_control(

			Group_Control_Text_Shadow::get_type(),

			array(

				'name'     => 'featured_text_shadow',

				'selector' => '{{WRAPPER}} .premium-woo-product-featured-wrap .premium-woo-product-featured',

			)

		);



		$this->add_group_control(

			Group_Control_Box_Shadow::get_type(),

			array(

				'name'     => 'featured_shadow',

				'selector' => '{{WRAPPER}} .premium-woo-product-featured-wrap .premium-woo-product-featured',

			)

		);



		$this->add_responsive_control(

			'featured_margin',

			array(

				'label'      => __( 'Margin', 'premium-addons-for-elementor' ),

				'type'       => Controls_Manager::DIMENSIONS,

				'size_units' => array( 'px', 'em', '%' ),

				'selectors'  => array(

					'{{WRAPPER}} .premium-woo-product-featured-wrap .premium-woo-product-featured' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				),

			)

		);



		$this->add_responsive_control(

			'featured_padding',

			array(

				'label'      => __( 'Padding', 'premium-addons-for-elementor' ),

				'type'       => Controls_Manager::DIMENSIONS,

				'size_units' => array( 'px', 'em', '%' ),

				'selectors'  => array(

					'{{WRAPPER}} .premium-woo-product-featured-wrap .premium-woo-product-featured' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				),

			)

		);



		$this->end_controls_section();



	}



	/**

	 * Register Style Quick View Controls.

	 *

	 * @since 4.7.0

	 * @access public

	 */

	public function register_quick_style_controls() {



		$this->start_controls_section(

			'section_quick_view_style',

			array(

				'label'     => __( 'Quick View Button', 'premium-addons-for-elementor' ),

				'tab'       => Controls_Manager::TAB_STYLE,

				'condition' => array(

					$this->get_control_id( 'quick_view' ) => 'yes',

					$this->get_control_id( 'quick_view_type' ) => 'button',

				),

			)

		);



		$this->add_group_control(

			Group_Control_Typography::get_type(),

			array(

				'name'     => 'qv_typography',

				'selector' => '{{WRAPPER}} .premium-woocommerce .premium-woo-qv-btn',

				'global'   => array(

					'default' => Global_Typography::TYPOGRAPHY_ACCENT,

				),

			)

		);



		$this->add_responsive_control(

			'qv_padding',

			array(

				'label'      => __( 'Padding', 'premium-addons-for-elementor' ),

				'type'       => Controls_Manager::DIMENSIONS,

				'size_units' => array( 'px', 'em', '%' ),

				'selectors'  => array(

					'{{WRAPPER}} .premium-woocommerce .premium-woo-qv-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				),

			)

		);



		$this->start_controls_tabs( 'qv_style_tabs' );



		$this->start_controls_tab(

			'qv_style_tab_normal',

			array(

				'label' => __( 'Normal', 'premium-addons-for-elementor' ),

			)

		);



		$this->add_control(

			'qv_color',

			array(

				'label'     => __( 'Color', 'premium-addons-for-elementor' ),

				'type'      => Controls_Manager::COLOR,

				'selectors' => array(

					'{{WRAPPER}} .premium-woocommerce .premium-woo-qv-btn' => 'color: {{VALUE}};',

				),

			)

		);



		$this->add_group_control(

			Group_Control_Background::get_type(),

			array(

				'name'     => 'qv_background',

				'types'    => array( 'classic', 'gradient' ),

				'selector' => '{{WRAPPER}} .premium-woocommerce .premium-woo-qv-btn',

			)

		);



		$this->add_group_control(

			Group_Control_Box_Shadow::get_type(),

			array(

				'name'     => 'qv_shadow',

				'selector' => '{{WRAPPER}} .premium-woocommerce .premium-woo-qv-btn',

			)

		);



		$this->add_group_control(

			Group_Control_Border::get_type(),

			array(

				'name'     => 'qv_border',

				'selector' => '{{WRAPPER}} .premium-woocommerce .premium-woo-qv-btn',

			)

		);



		$this->add_control(

			'qv_radius',

			array(

				'label'      => __( 'Border Radius', 'premium-addons-for-elementor' ),

				'type'       => Controls_Manager::DIMENSIONS,

				'size_units' => array( 'px', 'em', '%' ),

				'selectors'  => array(

					'{{WRAPPER}} .premium-woocommerce .premium-woo-qv-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',

				),

			)

		);



		$this->end_controls_tab();



		$this->start_controls_tab(

			'qv_style_tab_hover',

			array(

				'label' => __( 'Hover', 'premium-addons-for-elementor' ),

			)

		);



		$this->add_control(

			'qv_color_hover',

			array(

				'label'     => __( 'Color', 'premium-addons-for-elementor' ),

				'type'      => Controls_Manager::COLOR,

				'selectors' => array(

					'{{WRAPPER}} .premium-woocommerce .premium-woo-qv-btn:hover' => 'color: {{VALUE}}',

				),

			)

		);



		$this->add_group_control(

			Group_Control_Background::get_type(),

			array(

				'name'     => 'qv_background_hover',

				'types'    => array( 'classic', 'gradient' ),

				'selector' => '{{WRAPPER}} .premium-woocommerce .premium-woo-qv-btn:hover',

			)

		);



		$this->add_group_control(

			Group_Control_Box_Shadow::get_type(),

			array(

				'name'     => 'qv_shadow_hover',

				'selector' => '{{WRAPPER}} .premium-woocommerce .premium-woo-qv-btn:hover',

			)

		);



		$this->add_group_control(

			Group_Control_Border::get_type(),

			array(

				'name'     => 'qv_border_hover',

				'selector' => '{{WRAPPER}} .premium-woocommerce .premium-woo-qv-btn:hover',

			)

		);



		$this->add_control(

			'qv_radius_hover',

			array(

				'label'      => __( 'Border Radius', 'premium-addons-for-elementor' ),

				'type'       => Controls_Manager::DIMENSIONS,

				'size_units' => array( 'px', '%', 'em' ),

				'selectors'  => array(

					'{{WRAPPER}} .premium-woocommerce .premium-woo-qv-btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',

				),

			)

		);



		$this->end_controls_tab();



		$this->end_controls_tabs();



		$this->end_controls_section();



	}





	/**

	 * Render Main HTML.

	 *

	 * @since 1.5.0

	 * @access protected

	 */

	public function render() {



		$settings = $this->parent->get_settings();



		$skin = Skin_Init::get_instance( $this->get_id() );



		echo $skin->render( $this->get_id(), $settings, $this->parent->get_id() );

	}

}

